clear
theta = -pi/2:0.01:pi/2;
load Xopt;
load X_sub_opt;
load W_final_cgfr_a;
W_n = Xopt(:,1:2)*W_final_cgfr_a;
W_n_flipconj = conj(flipud(W_n));
W_n_opt = [W_n W_n_flipconj];
save W_n_opt.mat W_n_opt;
N=10;
E = N;

C_0 = trace(Xopt*Xopt');
Xopt = (Xopt/sqrt(C_0))*sqrt(10);

C_1 = trace(W_n_opt*W_n_opt');
W_n_opt = (W_n_opt/sqrt(C_1))*sqrt(10);

C_2 = trace(X_sub_opt*X_sub_opt');
X_sub_opt = (X_sub_opt/sqrt(C_2))*sqrt(10);


for i = 1:length(theta)
    for l = 1:N;
    a(l,1)=exp(1i*pi*sin(theta(i))*(l-1));
    end  
    A1(i) = abs(a'*Xopt(:,1) +a'*Xopt(:,2))
    A2(i) = abs(a'*W_n_opt(:,1) + a'*W_n_opt(:,2))
    B(i) = a'*eye(N)*a;
    C(i) = a'*W_n_opt*W_n_opt'*a;
    D(i) = a'*X_sub_opt*X_sub_opt'*a;    
    
   
    C1(i) = a'*W_n_opt(:,1)*W_n_opt(:,1)'*a;    
    C2(i) = a'*W_n_opt(:,2)*W_n_opt(:,2)'*a;
    C3(i) = a'*W_n_opt(:,3)*W_n_opt(:,3)'*a;
    C4(i) = a'*W_n_opt(:,4)*W_n_opt(:,4)'*a;
end



A1 = 10*log10(A1)
A2 = 10*log10(A2)
B = 10*log10(B);
C = 10*log10(C);
D = 10*log10(D);

C1 = 10*log10(C1);
C2 = 10*log10(C2);
C3 = 10*log10(C3);
C4 = 10*log10(C4);

theta = theta*180/pi;

figure(1)
plot(theta,A1,'b-',theta,A2,'r--')
figure(2)
plot(theta,C1,'m-',theta,C2,'g-',theta,C3,'r--',theta,C4,'b--',theta,C,'y--')
figure(3)
plot(theta,C,'b--',theta,D,'r--',theta,B,'g--')